/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: pgpClassesConfig.h,v 1.2 1999/09/17 04:20:46 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_pgpClassesConfig_h	// [
#define Included_pgpClassesConfig_h

// We don't work with STL yet.

#if defined(std)
#error Can't use this API and the C++ STL simultaneously.
#endif	// std

// Include this file in your source file before including any of the other
// PFL classes files (except for CPGPException.h, CComboError.h, and
// StPGPRefs.h).

// Base PFL includes

#include "pgpDebug.h"
#include "pgpLeaks.h"
#include "pgpMem.h"

#include "CComboError.h"


// Namespace macros

#define _PGP_BEGIN	namespace PGP {
#define _PGP_END	}
#define	_USING_PGP	using namespace PGP;

#define _UNNAMED_BEGIN	namespace {
#define _UNNAMED_END	}

// Macros

#if !defined(PGP_EXCEPTIONS)

#if defined(PGP_DRIVER98) || defined(PGP_DRIVERNT)
#define	PGP_EXCEPTIONS	FALSE
#else	// !(PGP_DRIVER98 || PGP_DRIVERNT)
#define	PGP_EXCEPTIONS	TRUE
#endif	// PGP_DRIVER98 || PGP_DRIVERNT

#endif	// !defined(PGP_EXCEPTIONS)

#if PGP_EXCEPTIONS

#define	SMART_ERROR			void
#define	SMART_ERROR_CALL
#define	SMART_ERROR_INHERIT
#define	SMART_ERROR_DECLARE
#define	SMART_ERROR_ASSIGN
#define	SMART_ERROR_RETURN	return;

#define THROW_PGPERROR(pgpError)										\
	do																	\
	{																	\
		throw CComboError(CComboError::kPGPError, pgpError);			\
	}																	\
	while (0)

#define THROW_OSERROR(osError)											\
	do																	\
	{																	\
		throw CComboError(CComboError::kPlatformError, osError);		\
	}																	\
	while (0)

#define THROW_ERRORS(pgpError, osError)									\
	do																	\
	{																	\
		CComboError	error;												\
																		\
		error.pgpErr = pgpError;										\
		error.err = osError;											\
																		\
		throw error;													\
	}																	\
	while (0)

#define THROW_IF_PGPERROR(pgpError)										\
	do																	\
	{																	\
		if (IsPGPError(pgpError))										\
			THROW_PGPERROR(pgpError);									\
	}																	\
	while (0)

#define THROW_IF_OSERROR(osError)										\
	do																	\
	{																	\
		if (osError == CComboError::kNoErr)								\
			THROW_OSERROR(osError);										\
	}																	\
	while (0)

#define THROW_IF_ERROR(error)											\
	do																	\
	{																	\
		if (error.IsError())											\
			throw error;												\
	}																	\
	while (0)

#else	// !PGP_EXCEPTIONS

#define	SMART_ERROR			CComboError
#define	SMART_ERROR_CALL	return
#define	SMART_ERROR_INHERIT	: public CErrorState
#define	SMART_ERROR_DECLARE	CComboError	error;
#define	SMART_ERROR_ASSIGN	error = 
#define	SMART_ERROR_RETURN	return error;

#endif	// PGP_EXCEPTIONS

#define UNUSED(a) a;

#define NOT_COPYABLE(type)												\
	private:															\
		type(const type& rhs);											\
		type&	operator=(const type& rhs);

#define DECLARE_MODALSTATE(type)										\
	NOT_COPYABLE(type)													\
																		\
	protected:															\
		type() { }														\
		~type() { }


// Other PFL includes

#include "PFLConstants.h"
#include "NewAndDelete.h"


// Platform includes

#if defined(PGP_DRIVER98)
#include "..\\..\\win32\\classes\\drv98\\pgpClassesConfigDrv98.h"
#elif defined(PGP_DRIVERNT)
#include "..\\..\\win32\\classes\\drvNT\\pgpClassesConfigDrvNT.h"
#elif defined(PGP_WIN32)
#include "..\\..\\win32\\classes\\pgpClassesConfigWin32.h"
#endif	// PGP_DRIVER98

#endif	// ] Included_pgpClassesConfig_h
